#!/bin/bash
set -e

PKG="/opt/bundled-debs/moxa-aig302-tpe_1.2.0_armhf.deb"
MAX_RETRY=60
DELAY=2

echo "[INFO] Trying to install $PKG with retry if dpkg is locked..."

for i in $(seq 1 $MAX_RETRY); do
    if fuser /var/lib/dpkg/lock >/dev/null 2>&1; then
        echo "[WARN] dpkg is locked (attempt $i), waiting $DELAY sec..."
    else
        echo "[INFO] dpkg lock is free, installing..."
        dpkg -i "$PKG" && echo "[INFO] Installed successfully." && break
    fi

    if [ "$i" -eq "$MAX_RETRY" ]; then
        echo "[ERROR] Failed to acquire dpkg lock after $MAX_RETRY attempts. Giving up."
        exit 1
    fi
    sleep $DELAY
done

rm -f "$PKG"
rmdir /opt/bundled-debs 2>/dev/null || true
