#!/bin/bash
echo 'CHMOD Started'
pushd "${PWD}" 1>> /dev/null

relative_path=$1
if [ -z "${relative_path}" ]; then
    echo -e "\e[31mchmod failed - no root dir defined\e[0m"
    popd 1>> /dev/null
    exit $result
fi
filter=$2
if [ -z "${filter}" ]; then
    filter="*.sh"
    echo Set filter to default $filter
fi
new_mode=$3
if [ -z "${new_mode}" ]; then
    new_mode=744
    echo Set mode to default $new_mode
fi
base_path=$4
if [ -z "${base_path}" ]; then
    base_path=$(cd "$(dirname "$0")" && pwd)
    echo Set script dir to default $base_path
fi
depth=$5
if [ -z "${depth}" ]; then
    depth=0
    echo Set depth to default $depth
fi

chmod_dir=$base_path/$relative_path
echo 'Script dir: ' $base_path
echo 'Change mode dir: ' $chmod_dir

if [[ ${depth} -ne 0 ]]; then
    files="$(find $chmod_dir -maxdepth $depth -type f -name $filter)"
else
    files="$(find $chmod_dir -type f -name $filter)"
fi

result=$?
if [[ $result -ne 0 ]]; then
    echo -e "\e[31mchmod failed - root dir is not found $chmod_dir with result $result\e[0m"
    popd 1>> /dev/null
    exit $result
fi
for file in $files; do
    echo "chmod $new_mode of $file"
    chmod $new_mode $file
    result=$?
    if [[ $result -ne 0 ]]; then
        echo -e "\e[31m$file chmod to $new_mode failed with result $result\e[0m"
        popd 1>> /dev/null
        exit $result
    fi
done
popd 1>> /dev/null
echo -e "\e[32mAll chmod passed\e[0m"
