# Moxa x86 Control Tools

## :bookmark_tabs: History
| **Version** | **Description of Change** | **Compatible Tools Version** | **Author** | **Date** |
| - | - | - | - | - |
| 0.1 | Initial Content | 1.6.0 | Elvis Yao | 20230718 |

---

## :blue_book: Introduction

### Purpose

The **Moxa x86 Control Tools** provide Linux peripheral control tools and configuration files for specific platforms. The peripheral interfaces include serial port, digital IO, relay, LED, and cellular modules (power and SIM select).

### Prerequisite

See [Moxa Docs](https://docs.moxa.online/mil/manuals/intro) to install the necessary peripheral drivers or packages for specific model.

---

## :hammer: Peripheral Control Tool

### [UART] Moxa Serial Port Control
The purpose of Moxa serial port mode control tool `mx-uart-ctl` is for getting and setting serial UART ports mode.
- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| EHL | BXP-A100, DRP-A100, RKP-A110 |
| TGL | BXP-C100, DRP-C100, RKP-C110, V3000, MC-3201, EXPC-F2000 |
| WHL | V2406C-WL, DA680 |
| KBL | V2403C, V2406C-KL, DA-820C, DA-682C, DA-681C, MC-1200 |
| Others | V2201 |

- Usage of `mx-uart-ctl`

```
Usage:
                mx-uart-ctl -p <port_number> [-m <uart_mode>]

OPTIONS:
                -p <port_number>
                                Set target port.
                -m <uart_mode>
                                Set target port to uart_mode
                                0 --> set to RS-232 mode
                                1 --> set to RS-485-2W mode
                                2 --> set to RS-422 mode
                                3 --> set to RS-485-4W mode

Example:
                Get mode from port 0
                # mx-uart-ctl -p 0

                Set port 1 to mode RS232
                # mx-uart-ctl -p 1 -m 0
```

### [UART] setinterface
The `setinterface` program is for getting and setting serial port mode via IOCTL.

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| Others | DA-720 |

- Usage of `setinterface`

```
Usage: setinterface device-node [interface-no]
        device-node     - /dev/ttyM0 ~ /dev/ttyM7
        interface-no    - following:
        none - to view now setting
        0 - set to RS232 interface
        1 - set to RS485-2WIRES interface
        2 - set to RS422 interface
        3 - set to RS485-4WIRES interface
```

### [DIO] Moxa Digital IO Port Control
Moxa DIO port control tool `mx-dio-ctl` is for getting DI/DO and setting DO ports status (low/high).

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| EHL | BXP-A100, DRP-A100, RKP-A110 |
| TGL | BXP-C100, DRP-C100, RKP-C110, V3000 |
| WHL | V2406C-WL, DA680 |
| KBL | V2403C, V2406C-KL, DA-820C, DA-682C, DA-681C |
| Others | V2201 |

- Usage of `mx-dio-ctl`

```
Usage:
        mx-dio-ctl <-i|-o <#port number> [-s <#state>]>

OPTIONS:
        -i <#DIN port number>
        -o <#DOUT port number>
        -s <#state>
                Set state for target DOUT port
                0 --> LOW
                1 --> HIGH

Example:
        Get value from DIN port 0
        # mx-dio-ctl -i 0
        Get value from DOUT port 0
        # mx-dio-ctl -o 0

        Set DOUT port 0 value to LOW
        # mx-dio-ctl -o 0 -s 0
        Set DOUT port 0 value to HIGH
        # mx-dio-ctl -o 0 -s 1
```

### [LED] Moxa LED Control
The purpose of Moxa LED control tool `mx-led-ctl` is for getting programmable LED and setting programmable LED status (on/off).

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| TGL | V3000 |
| WHL | DA680 |
| KBL | DA-820C, DA-682C, DA-681C |
| Others | V2201 |

- Usage of `mx-led-ctl`

```
Usage:
		mx-led-ctl -i <led_index> [on|off]

OPTIONS:
		-i <led_index>
				Set LED index.

Example:
		Get state from index 1
		# mx-led-ctl -i 1

		Set index 1 to on
		# mx-led-ctl -i 1 on
```

### [LED] Moxa EXPC LED Control
The purpose of Moxa EXPC LED control tool `mx-expc-led-ctl` is for controlling Panel Multi function LED mode (LAN, UART_TX, UART_RX).

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| TGL | EXPC-F2000 |

- Usage of `mx-expc-led-ctl`

```
Usage:
        mx-expc-led-ctl -i <led_index> [LAN1|LAN2|LAN3|LAN4|UART1_TX|UART2_TX|UART3_TX|UART1_RX|UART2_RX|UART3_RX]

OPTIONS:
        -i <led_index>
                Set LED index.

Example:
        Get mode from index 0
        # mx-expc-led-ctl -i 0

        Set LED index 0 to LAN1 mode
        # mx-expc-led-ctl -i 0 LAN1

        Set LED index 1 to UART3_TX mode
        # mx-expc-led-ctl -i 1 UART3_TX
```

### [Relay] Moxa Relay Control
The purpose of Moxa Relay control tool `mx-relay-ctl` is for getting relay and setting relay status (NC/NO).

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| WHL | DA680 |
| KBL | DA-820C, DA-682C, DA-681C |

- Usage of `mx-relay-ctl`

```
Usage:
		mx-relay-ctl -p <port_number> [-m <relay_mode>]

OPTIONS:
		-p <port_number>
				Set target port.
		-m <relay_mode>
				Set target port to relay_mode
				0 --> set to NC (Normal Closed) mode
				1 --> set to NO (Normal Open) mode

Example:
		Get mode from port 0
		# mx-relay-ctl -p 0

		Set port 0 to mode NC
		# mx-relay-ctl -p 0 -m 0

		Set port 0 to mode NO
		# mx-relay-ctl -p 0 -m 1
```

### [Module] Moxa Cellular Module Control (form factor: mPCIe)
The Moxa Cellular Module Control tool (mPCIe form factor) `mx-module-ctl` provides the following operations for cellular module: power on/off, select SIM slot and reset pin control.

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| TGL | V3000 |
| WHL | V2406C-WL |
| KBL | V2403C, V2406C-KL, MC-1200 |
| Others | V2201 |

- Usage of `mx-module-ctl`

```
Usage:
       mx-module-ctl [Options]

Operations:
       -s, --slot <module_slot_id>
               Select module slot
       -p, --power [on|off]
               Get/Set power on/off module
       -r, --reset [on|off]
               Get/Set reset pin to high(on)/low(off) to slot
       -i, --sim 1|2
               Get/Set sim card slot

Example:
       Power on module 1
       # mx-module-ctl -s 1 -p on

       Set module 2 reset pin to high
       # mx-module-ctl -s 2 -r on

       Select SIM 2 for module 1
       # mx-module-ctl -s 1 -i 2

       Get power status of module 1
       # mx-module-ctl -s 1 -p

       Get current SIM slot of module 1
       # mx-module-ctl -s 1 -i
```

### [Module] Moxa Cellular Module Control (form factor: M.2 B Key)
The Moxa Cellular M2B Module Control tool (M.2 B Key form factor) `mx-m2b-module-ctl` provides the following operations for cellular module: power on/off, select SIM slot and reset pin control.

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| TGL | V3000 |

- Usage of `mx-m2b-module-ctl`

```
Usage:
       mx-m2b-module-ctl [Options]

Operations:
       -s, --slot <module_slot_id>
               Select module slot
       -p, --pwren [high|low]
               Get/Set power enable pin high/low status
       -t, --turnon [high|low]
               Get/Set turn-high pin high/low status
       -r, --reset [high|low]
               Get/Set reset pin high/low status
       -a, --airplane [high|low]
               Get/Set airplane pin high/low status
       -i, --sim 1|2
               Get/Set sim card slot 1/2
       -m, --mod_status 1|2
               Get module and config status

Example:
       Set power enable to [high] status for module 1
       # mx-m2b-module-ctl -s 1 -p high
       Get power enable pin status of module 1
       # mx-m2b-module-ctl -s 1 -p

       Set turn-on pin to [high] status for module 1
       # mx-m2b-module-ctl -s 1 -t high
       Get turn-on pin status of module 1
       # mx-m2b-module-ctl -s 1 -t

       Set reset pin to [low] status for module 2
       # mx-m2b-module-ctl -s 2 -r low
       Get reset pin status of module 2
       # mx-m2b-module-ctl -s 2 -r

       Set airplane pin to [low] status for module 2
       # mx-m2b-module-ctl -s 2 -a low
       Get airplane pin status of module 2
       # mx-m2b-module-ctl -s 2 -a

       Select SIM slot 2 for module 2
       # mx-m2b-module-ctl -s 2 -i 2
       Get current SIM slot of module 2
       # mx-m2b-module-ctl -s 2 -i

       Get module 2 status
       # mx-m2b-module-ctl -s 2 -m
```

### [Audio] Moxa Audio Retask
The Moxa Audio Retask `mx-audio-retask` is a tool for the audio jack would prompt a connector retasking for headphone, headset, mic in/out, line in/out, etc.

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| WHL | V2406C-WL |
| KBL | V2403C, V2406C-KL |
| Others | MC-7400 |

- Usage of `mx-audio-retask`

```
Usage:
        mx-audio-retask [Options]

Operations:
        -p,--port <port_index>
                Select Jack Index (e.g. 1, 2, ...)
        -m,--mode <jack_mode>"
                Select Jack Mode [0|1|2|3|4]

Jack Mode:
        0 --> Set to LINE_OUT mode
        1 --> Set to SPEAKER mode
        2 --> Set to HEADPHONE mode
        3 --> Set to LINE_IN mode
        4 --> Set to MICROPHONE mode

Example:
        Get Jack 1 mode
        # mx-audio-retask -p 1
        Set Jack 2 to HEADPHONE mode
        # mx-audio-retask -p 2 -m 2
```

### [Power] Moxa Power Ignition Daemon
The Moxa Power Ignition Daemon is a tool for monitoring the status power ignition pin and run shutdown when power igition input signal is off.

- Available models:

| **CPU Gen.** | **Model Name** |
| - | - |
| KBL | V2403C |

- The file list of Moxa Power Ignition Daemon
  - mx-power-igtd
  - moxa-power-igtd.service

---

## :bookmark: Reference

- Moxa Docs Center https://docs.moxa.online/
