#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

drv::is_loaded() {
        local drv_name
        drv_name="$1"

        lsmod | grep -wq "${drv_name}"
}

drv::is_ignored() {
        local module_name
        module_name="$1"

        modprobe --show-config | grep -qw "blacklist ${module_name}"
}

drv::add_blacklist() {
        local module_names
        local conf_file
        local is_added

        module_names="$1"
        conf_file="/lib/modprobe.d/$2"
        is_added=""

        if [[ ! -e "$conf_file" ]]; then
                touch "$conf_file"
        fi

        for mod in ${module_names}; do
                if ! drv::is_ignored "$mod"; then
                        echo "blacklist $mod" >>"$conf_file"
                        echo "install $mod /bin/false" >>"$conf_file"
                        is_added+=" $mod"
                fi
        done

        echo "$is_added"
}
