#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-sdhci-pci-driver"
SRC_PATH_PREFIX="${INSTL_TOP_DIR}/src/${REPO_NAME}"

main() {
        local src_tag
        local src_ver
        src_tag="$1"
        src_ver="$2"

        log::info "Installing ${REPO_NAME} (${src_ver})"

        {
                pushd "${SRC_PATH_PREFIX}-${src_tag}" >/dev/null

                make clean
                make
                make install

                popd

                if [[ "${LINUX_DISTRO_ID}" == "debian" ]] && [[ "${LINUX_KERNEL_MAJOR_VER}" == "5" ]] && [[ "${LINUX_KERNEL_MINOR_VER}" == "10" ]]; then
                        cat <<EOF >/lib/modprobe.d/sdhci-pci-option.conf
options sdhci-pci enable_probe_cd_gpio=0
EOF
                        update-initramfs -u -k "$(uname -r)"
                fi
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
