/*
	Copyright (C) MOXA Inc. All rights reserved.

	This software is distributed under the terms of the
	MOXA License.  See the file COPYING-MOXA for details.
*/
#pragma once
#include <iostream>
#include <string>
using namespace std;

#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif
	enum RETURN_STATUS
	{
		ACTION_SUCCESS = 0,
		ACTION_ERROR = -1,
		LIB_INITIALIZE_FAIL = -2,
		PORT_OUTOF_INDEX = -3,
		SET_STATUS_ERR = -4,
		INVALID_MODULE = -5,
		ACTION_TIMEOUT = -6
	};
	
	HMODULE GetCurrentModule();
	int InitMX5GPOWER(void);

	WORD GetVendorConfigFromModule(int port);
	int GetVendorIndexFromProfile(int port, WORD config);
	int SetM2BMainPower(int port, int value);
	int GetModuleStatus(int port);
	int SetModulePower(int port, int value);
	int PowerOn(int port);
	int PowerOff(int port);
	int ResetModule(int port);

	bool CheckModuleValidation(int port);
	int GetPowerStatus(int port);
	int SetPowerStatus(int port, int status);

#ifdef __cplusplus    // If used by C++ code, 
}
#endif
